/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.utility.CreatePaths;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;

@GameTestGroup(path="misc")
public class TestMisc {
    @GameTest(template="schematicannon", timeoutTicks=300)
    public static void schematicannon(CreateGameTestHelper helper) {
        BlockPos whiteEndBottom = helper.m_177449_(new BlockPos(5, 2, 1));
        BlockPos redEndTop = helper.m_177449_(new BlockPos(5, 4, 7));
        ServerLevel level = helper.m_177100_();
        SchematicExport.saveSchematic(CreatePaths.UPLOADED_SCHEMATICS_DIR.resolve("Deployer"), "schematicannon_gametest", true, (Level)level, whiteEndBottom, redEndTop);
        ItemStack schematic = SchematicItem.create((Level)level, "schematicannon_gametest.nbt", "Deployer");
        BlockPos anchor = helper.m_177449_(new BlockPos(1, 2, 1));
        schematic.m_41784_().m_128379_("Deployed", true);
        schematic.m_41784_().m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)anchor));
        BlockPos cannonPos = new BlockPos(3, 2, 6);
        SchematicannonBlockEntity cannon = (SchematicannonBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SCHEMATICANNON.get(), cannonPos);
        cannon.inventory.setStackInSlot(0, schematic);
        cannon.state = SchematicannonBlockEntity.State.RUNNING;
        cannon.statusMsg = "running";
        helper.m_177361_(() -> {
            if (cannon.state != SchematicannonBlockEntity.State.STOPPED) {
                helper.m_177284_("Schematicannon not done");
            }
            BlockPos lastBlock = new BlockPos(1, 4, 7);
            helper.m_177208_(Blocks.f_50108_, lastBlock);
        });
    }

    @GameTest(template="shearing")
    public static void shearing(CreateGameTestHelper helper) {
        BlockPos sheepPos = new BlockPos(2, 1, 2);
        Sheep sheep = (Sheep)helper.getFirstEntity(EntityType.f_20520_, sheepPos);
        sheep.m_5851_(SoundSource.NEUTRAL);
        helper.m_177361_(() -> helper.m_177194_(Items.f_41870_, sheepPos, 2.0));
    }

    @GameTest(template="smart_observer_blocks")
    public static void smartObserverBlocks(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 2, 1);
        BlockPos leftLamp = new BlockPos(3, 4, 3);
        BlockPos rightLamp = new BlockPos(1, 4, 3);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.m_177255_(leftLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
            helper.m_177255_(rightLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
        });
    }

    @GameTest(template="threshold_switch_pulley")
    public static void thresholdSwitchPulley(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(3, 7, 1);
        BlockPos switchPos = new BlockPos(1, 6, 1);
        BlockPos finalPos = new BlockPos(2, 2, 1);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            int expectedLevel;
            ThresholdSwitchBlockEntity switchBe = (ThresholdSwitchBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.THRESHOLD_SWITCH.get(), switchPos);
            int level = switchBe.getStockLevel();
            if (level != (expectedLevel = helper.m_177449_(finalPos).m_123342_())) {
                helper.m_177284_("Unexpected level: " + level);
            }
        });
    }

    @GameTest(template="netherite_backtank", timeoutTicks=200)
    public static void netheriteBacktank(CreateGameTestHelper helper) {
        BlockPos lava = new BlockPos(2, 2, 3);
        BlockPos zombieSpawn = lava.m_6630_(2);
        BlockPos armorStandPos = new BlockPos(2, 2, 1);
        helper.m_177127_(5L, () -> {
            Zombie zombie = (Zombie)helper.m_177176_(EntityType.f_20501_, zombieSpawn);
            ArmorStand armorStand = (ArmorStand)helper.getFirstEntity(EntityType.f_20529_, armorStandPos);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                zombie.m_8061_(slot, armorStand.m_6844_(slot).m_41777_());
            }
        });
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(9);
            helper.m_177374_(EntityType.f_20501_, lava);
        });
    }
}

